%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Example 6.1
% File: NLSestimation.m
%
% Nonlinear least square estimation of ExpAR(1) model. 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function NLSestimation
T      = 200+2;  
par(1) = -0.8;   
par(2) = 2;  
par(3) = 2;
LB     = [-0.9	0.55	1.9];
UB     = [-0.7	3.45	2.1];

nrep    = 1000;               % Number of MC replications
options = optimset('GradObj','on');
options = optimset('Display','off');

for iter=1:nrep;   
    fprintf('Iteration =  %f\n',iter);
    R = normrnd(0,1,T+1,1);

    % Define the data sets that you are trying to fit the function to.
    Y(1) = 0;           % Start value
    for i=2:T+1
       Y(i) = (par(1)+par(2)*eps(-par(3).*Y(i-1).*Y(i-1))).*Y(i-1)+R(i);  
    end
    YY = Y(length(Y)-100:T+1);    % Delete first 100 observations
    nr=length(YY);

%   Start to initialize coefficients of the ExpAR(1) process
    for j=1:nr
        gamma = 1.75+0.005*(j-1); % Number of grid points around gamma
        for i=2:T-nr
           ZZ2(i-1) = exp(-gamma.*YY(i-1).*YY(i-1)).*YY(i-1);
           ZZ1(i-1) = YY(i-1);            
        end
        for i=1:T-nr-1
            W(i) = YY(i+1);
        end
        X = [ZZ1' ZZ2'];  
        b = X\W';              % LS estimation
        sig22       = var((W'-X*b),1);
        X0(j,:)     = [b'  gamma];       
        sigma2(:,j) = sig22;
    end

    [~,ind] = nanmin(sigma2);  % Find minimum index
    X00 = X0(ind,:);           % Associated best initial values
%   End initialization

    X00iter(iter,:) = X00;     % Best initial estimates per iteration       
    estimates = fmincon(@myfitgrad,X00,[],[],[],[],LB,UB,[],options,W);
    x1          = estimates;       
    xx1(iter,:) = x1;          % Nonlinear estimates   
end   

MeanTot = [mean(X00iter); mean(xx1)]; % Initial OLS, Final fmincon estimates
MeanTot

%   Bias
BiasNLS1 = par - mean(xx1);
BiasOLS  = par - mean(X00iter);
    
for i=1:nrep;
  biasNLS1(i,:) = (par - xx1(i,:));
  biasOLS(i,:)  = (par - X00iter(i,:));
end;    

assignin('base', 'biasNLS1', biasNLS1);
assignin('base', 'MeanTot', MeanTot);

function [F,g] = myfitgrad(x,W)
% This function is called by lsqnonlin.
% x is a vector which contains the coefficients of the
% equation. W is the option data sets that were
% passed to lsqnonlin.

Z = W;
n = length(Z);
A = x(1);
B = x(2);
C = x(3);

f(1) = 0;

i=2:n;
f(i) = (A + B*exp(-C*Z(i-1).*Z(i-1))).*Z(i-1);
F = sum(f);

if nargout >1
   g1 = zeros(n,1);
   g2 = zeros(n,1);
   g3 = zeros(n,1);
   
   for i=2:n;
     g1(i) = (Z(i)-f(i)).*Z(i-1);
     g2(i) = (Z(i)-f(i)).*Z(i-1)*exp(-C.*Z(i-1).*Z(i-1));
     g3(i) = -B.*(Z(i)-f(i)).*Z(i-1).*Z(i-1).*Z(i-1)*exp(-C.*Z(i-1).*Z(i-1));
   end
g = [sum(g1) sum(g2) sum(g3)];
end


